<?php
/**
 *
 * No private messages to ignored users. An extension for the phpBB Forum Software package.
 *
 * @copyright (c) 2025, Chris1278
 * @license GNU General Public License, version 2 (GPL-2.0)
 *
 */

namespace chris1278\nopnignore\event;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class listener implements EventSubscriberInterface
{
	protected $db;
	protected $user;
	protected $template;
	protected $language;

	public function __construct(
		\phpbb\db\driver\driver_interface $db,
		\phpbb\user $user,
		\phpbb\template\template $template,
		\phpbb\language\language $language
	)
	{
		$this->db			= $db;
		$this->user			= $user;
		$this->template		= $template;
		$this->language		= $language;

	}

	public static function getSubscribedEvents()
	{
		return [
			'core.ucp_display_module_before'	=> 'change_zebra_explain',
			'core.message_list_actions'			=> 'block_pn_ignore',
		];
	}

	public function change_zebra_explain()
	{
		$this->language->add_lang('nopnignore', 'chris1278/nopnignore');
		$this->template->assign_vars([
			'L_FOES_EXPLAIN'					=> $this->language->lang('CE_FOES_EXPLAIN'),
		]);
	}

	public function block_pn_ignore($event)
	{
		//This process starts as soon as you want to add users to the address list and attempt to fill the array.
		if (!empty($event['address_list']))
		{
			$this->language->add_lang('nopnignore', 'chris1278/nopnignore');
			$new_list	= [];
			$errormsg	= [];
			$keys		= [];
			$values		= [];

			//Here we separate the key, which contains the recipient ID, and the value, which contains either to or bcc.
			foreach ($event['address_list']['u'] as $key => $value)
			{
				//Next, we check whether the user is being ignored by the recipient or not. Depending on the result, the ID is added to the recipients' list or a corresponding message is displayed.
				if ($this->user->data['user_id'] != $this->check_zebra($key))
				{
					$keys[]		= $key;
					$values[]	= $value;
				}
				else
				{
					$user 			= $this->find_username($key);
					$user_color		= (!empty($user['user_colour'])) ? $user['user_colour'] : '';

					$errormsg[]	= $this->language->lang('CE_NOIGNORMESSAGE', $user['username'], $user_color);
				}
				$new_list['u'] = array_combine($keys, $values);
			}

			//At this point, we've included the usual error messages that should be displayed due to other forum settings.
			foreach ($event['error'] as $msg)
			{
				$errormsg[] = $msg;
			}
			//Here we pass the revised recipient list back into the flow.
			$event['address_list'] = $new_list;

			//Here we pass the error messages back into the process.
			$event['error'] = $errormsg;
		}
	}

	//This function allows us to check whether the user who wants to send a private message is being ignored by the recipient.
	public function check_zebra($value)
	{
		$sql = 'SELECT zebra_id
				FROM ' . ZEBRA_TABLE . '
					WHERE ' . $this->db->sql_in_set('user_id', $value) . '
					AND ' . $this->db->sql_in_set('foe', 1);
		$result = $this->db->sql_query($sql);
		$zebra_id	= $this->db->sql_fetchfield('zebra_id');
		$this->db->sql_freeresult($result);

		return $zebra_id;
	}

	//At this point, we determine the username of the user who ignored the PM sender for the error output.
	public function find_username($value)
	{
		$sql = 'SELECT username, group_id, user_colour
				FROM ' . USERS_TABLE . '
					WHERE ' . $this->db->sql_in_set('user_id', $value);
		$result = $this->db->sql_query($sql);
		$find_username	= $this->db->sql_fetchrow($result);
		$this->db->sql_freeresult($result);

		return $find_username;
	}
}
